from influxdb import InfluxDBClient
from influxdb import SeriesHelper
import configparser
import logging
import protocol

class MySeriesHelper(SeriesHelper):
    
    # Meta class stores time series helper configuration.
    class Meta:
        # The client should be an instance of InfluxDBClient.
        #client = myclient
        # The series name must be a string. Add dependent fields/tags in curly brackets.
        series_name = '{measurement}'
        # Defines all the fields in this time series.
        fields = ['value']
        # Defines all the tags for the series.
        tags = ['measurement']
        # Defines the number of data points to store prior to writing on the wire.
        bulk_size = 5
        # autocommit must be set to True when using bulk_size
        autocommit = True

class Database:
    
    def __init__(self, config):
        self.logger = logging.getLogger('hydrobot')
        host = config.get("database", "host")
        port = config.get("database", "port")
        username = config.get("database", "username")
        password = config.get("database", "password")
        self.database = config.get("database", "database")
        self.name = config.get("system", "name")
        
        try:
            self.client = InfluxDBClient(host, port, username, password, self.database)
            MySeriesHelper.Meta.client = self.client
            MySeriesHelper.Meta.series_name = self.name + '.{measurement}'
            self.logger.info("Connected to database")
        except:
            self.logger.error("Could not connect to database")
        
        # To manually submit data points which are not yet written, call commit:
        #MySeriesHelper.commit()
            
    def log_message(self, name, message):
        data_name = protocol.lookup_data_name_by_key(message.data_key)
        if not data_name == None:
            if message.sensor_num > 0:
                num = "_" + str(message.sensor_num)
            else:
                num = ""
            try:
                self.logger.debug("Database log: " + name + "." + data_name + num)
                MySeriesHelper(measurement=(name + "." + data_name + num), value=(float)(message.data))
            except:
                self.logger.error("Database issue!")
        else:
            self.logger.warning("Unknown data key: " + str(message))

    def read_value(self, name, data_name, sensor_num):
        #try:
        
        if sensor_num > 0:
            num = "_" + str(sensor_num)
        else:
            num = ""
        measurement = "\"" + self.name + "." + name + "." + data_name + num + "\""
        results = self.client.query(("SELECT last(\"value\") from %s") % (measurement))
        points = results.get_points()
        for item in points:
            return item["last"]
            

        #except:
        #    self.logger.error("Database issue!")
    
        
        
        
