#!/usr/bin/env python

import sys
import time
import signal
import configparser
import logging

import network
import network_interface
from message import HydroBotMessage
import module
import protocol
from database import Database
from scheduler import Scheduler
import alerts


#TODO
#add periodic output refresh
#add output cleanup on shutdown
#validate config settings on load

#load config file
config = configparser.ConfigParser(allow_no_value = True)
config.read("hydrobot.conf")

#set up logger
logger = logging.getLogger('hydrobot')
log_level = config.get("system", "log_level")
levels = {"CRITICAL" : 50, "ERROR" : 40, "WARNING" : 30, "INFO" : 20, "DEBUG" : 10, "NOTSET" : 0}
logger.setLevel(levels[log_level])

fh = logging.FileHandler('hydrobot.log')
fh.setLevel(logging.INFO)
formatter = logging.Formatter('[%(asctime)s][%(levelname)s][%(module)s][%(funcName)s] %(message)s') #('%(asctime)s - %(name)s - %(levelname)s - %(message)s')
fh.setFormatter(formatter)
logger.addHandler(fh)

ch = logging.StreamHandler(sys.stdout)
ch.setLevel(logging.DEBUG)
formatter = logging.Formatter('[%(asctime)s][%(levelname)s][%(module)s][%(funcName)s] %(message)s') #('%(asctime)s - %(name)s - %(levelname)s - %(message)s')
ch.setFormatter(formatter)
logger.addHandler(ch)

logger.info('Logger initialized')

def main(argv):
    
    logger.info("Starting HydroBot!")

    #if len(argv) < 1:
    #    logger.error("Please specify a can interface")
    #    return 1

    database = Database(config)
    
    module_network = network.Network(database, config)
    module_network.start_all_interfaces()
    
    scheduler = Scheduler(module_network, config)
    scheduler.start()
    
    alert_manager = alerts.AlertManager(database, config)
    
    #alert_manager.evaluate_alerts()

    while True:
        time.sleep(0.1)
        
def close_program(signum, frame):
    logger.info("Closing now!")
    sys.exit(0)
        
signal.signal(signal.SIGINT, close_program)

if __name__ == "__main__":
    main(sys.argv[1:])
