import json

_protocol_def = None

with open('hydrobot_def.json') as def_file:
    _protocol_def = json.load(def_file)

def lookup_device_name_by_id(id):
    devices = _protocol_def['devices']
    for device in devices:
        if int(device.get('id'), 16) == id:
            return device.get('name')

def lookup_device_id_by_name(name):
    devices = _protocol_def['devices']
    for device in devices:
        if device.get('name') == name:
            return int(device.get('id'), 16)
        
def lookup_device_display_by_id(id):
    devices = _protocol_def['devices']
    for device in devices:
        if int(device.get('id'), 16) == id:
            return device.get('display')
        
def lookup_device_class_by_id(id):
    devices = _protocol_def['devices']
    for device in devices:
        if int(device.get('id'), 16) == id:
            return device.get('class')
        
def lookup_device_display_by_name(name):
    devices = _protocol_def['devices']
    for device in devices:
        if device.get('name') == name:
            return device.get('display')

def lookup_data_name_by_key(key):
    data_keys = _protocol_def['data_keys']
    for data_key in data_keys:
        if int(data_key.get('key'), 16) == key:
            return data_key.get('name')

def lookup_data_key_by_name(name):
    data_keys = _protocol_def['data_keys']
    for data_key in data_keys:
        if data_key.get('name') == name:
            return int(data_key.get('key'), 16)

def lookup_data_display_by_key(key):
    data_keys = _protocol_def['data_keys']
    for data_key in data_keys:
        if int(data_key.get('key'), 16) == key:
            return data_key.get('display')

def lookup_command_name_by_key(key):
    commands = _protocol_def['command_keys']
    for command in commands:
        if int(data_key.get('key'), 16) == key:
            return command.get('name')

def lookup_command_key_by_name(name):
    commands = _protocol_def['command_keys']
    for command in commands:
        if command.get('name') == name:
            return int(command.get('key'), 16)

def lookup_command_display_by_key(key):
    commands = _protocol_def['command_keys']
    for command in commands:
        if int(command.get('key'), 16) == key:
            return command.get('display')
            
def lookup_sensors_by_device_name(name):
    devices = _protocol_def['devices']
    for device in devices:
        if device.get('name') == name:
            return device.get('sensors')
    
