/*
  Copyright © 2014 Uwe Rathmann

  This file is copied from Qwt project; you can redistribute it and/or modify it
  under the terms of the Qwt License, Version 1.0. You can obtain the original
  source code and the details of the Qwt License from the Qwt website:
  http://qwt.sourceforge.net/
*/

#ifndef _SCROLLZOOMER_H
#define _SCROLLZOOMER_H

#include <qglobal.h>
#include <qwt_plot_zoomer.h>
#include <qwt_plot.h>

class ScrollData;
class ScrollBar;

class ScrollZoomer: public QwtPlotZoomer
{
    Q_OBJECT
public:
    enum ScrollBarPosition
    {
        AttachedToScale,
        OppositeToScale
    };

    ScrollZoomer( QWidget * );
    virtual ~ScrollZoomer();

    ScrollBar *horizontalScrollBar() const;
    ScrollBar *verticalScrollBar() const;

    void setHScrollBarMode( Qt::ScrollBarPolicy );
    void setVScrollBarMode( Qt::ScrollBarPolicy );

    Qt::ScrollBarPolicy vScrollBarMode () const;
    Qt::ScrollBarPolicy hScrollBarMode () const;

    void setHScrollBarPosition( ScrollBarPosition );
    void setVScrollBarPosition( ScrollBarPosition );

    ScrollBarPosition hScrollBarPosition() const;
    ScrollBarPosition vScrollBarPosition() const;

    QWidget* cornerWidget() const;
    virtual void setCornerWidget( QWidget * );

    virtual bool eventFilter( QObject *, QEvent * );

    void setXLimits(double min, double max);
    void setHViewSize(double size);
    virtual void setZoomBase(bool doReplot = true);
    virtual void rescale();

public Q_SLOTS:
    virtual void moveTo( const QPointF & );

protected:
    virtual ScrollBar *scrollBar( Qt::Orientation );
    virtual void updateScrollBars();
    virtual void layoutScrollBars( const QRect & );

private Q_SLOTS:
    void scrollBarMoved( Qt::Orientation o, double min, double max );

private:
    enum class AlignZoomBase
    {
        Right, Center, Left
    };

    QRectF d_limits;
    double xMin, xMax;
    double hViewSize;
    /// used for aligning zoom base during xlimits change
    AlignZoomBase zbAlign;

    bool needScrollBar( Qt::Orientation ) const;
    int oppositeAxis( int ) const;

    QWidget *d_cornerWidget;

    ScrollData *d_hScrollData;
    ScrollData *d_vScrollData;

    bool d_inZoom;
    bool d_alignCanvasToScales[ QwtPlot::axisCnt ];
    bool hscrollmove;
    bool vscrollmove;
};

#endif
